#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define R 0.075f
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

#define SQRT3 1.732050807
#define PI 3.141592653


vec2 hexCenter(vec2 id, float odd)
{
	return (vec2)(
		SQRT3 * R * (id.x +0.5f*odd),
		1.5f * id.y * R
		);
}

__kernel void MAIN(
      __read_only image2d_t input,  
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha,
      int Fall_off,
      int Offset,
      int Fish) 
{
    int outputW = param->width[1];
	int outputH = param->height[1];
    int W = get_global_size(0);
	int H = get_global_size(1);
    float2 ouputResolution = (float2)(W,H);

    float fall_off = (float)(Fall_off)/100.0f;
    float offset  = (float)(Offset)/10.0f;
    float fish  = (float)(Fish)/10.0f;
  
    int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));

    vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((float2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/ouputResolution.xy;
    vec2 resolution = ouputResolution;
    float roiLeft = param->origROI[0];
    float roiTop = param->origROI[1];
    float roiWidth  = param->origROI[2];
    float roiHeight  = param->origROI[3];
    //vec2 tranformCoord = (vec2)(roiWidth * tc.x + roiLeft , roiHeight * tc.y + roiTop);
    vec2 uv = (float2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
    
    float4 orig = read_imagef(input, sampler, uv);  

     //UV coordinates [1,2]
	uv = tc;
	uv.xy += 1.0f;
	vec2 grid;

	//Estimate hex coordinate
	grid.y = floor(uv.y / (1.5f*R));
	float odd = fmod(grid.y, 2.0f);
	grid.x = floor(uv.x / (SQRT3 * R) - odd*0.5f);

	//Find possible centers of hexagons
	vec2 h1 = hexCenter(grid, odd);
	vec2 h2 = hexCenter(grid + (vec2)(1.0f,0.0f), odd);
	vec2 h3 = hexCenter(grid + (vec2)(odd, 1.0f), 1.0f-odd);

	//Find closest center
	float d1 = dot(h1-uv, h1-uv);
	float d2 = dot(h2-uv, h2-uv);
	float d3 = dot(h3-uv, h3-uv);
    
	if (d2 < d1)
	{
		d1 = d2;
		h1 = h2;
	}
	if (d3 < d1)
	{
		d1 = d3;
		h1 = h3;
	}
	
    //Hexagon UV
	vec2 uv2 = uv - h1;
    
    //Set Hexagon offset
	uv = (uv.xy - 1.0f) + uv2 * offset;

    //Per Facet Fisheye effect (optional)
	vec2 coords = (uv2 - 0.5f*R) * 2.0f;
	vec2 fisheye;
	fisheye.x = (1.0f - coords.y * coords.y) * fish * (coords.x);
	fisheye.y = (1.0f - coords.x * coords.x) * fish * (coords.y);
	uv -= fisheye*R;


    //Retrieve texture colour
    uv = (float2)(uv.x, uv.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
    vec4 fragColor = read_imagef(input, sampler, uv);  
  

    //Redude corners (optional)
	fragColor = max((vec4)(0.0f), fragColor - length(2.0f*uv-1.0f)*fall_off); 
    vec4 retColor =  mix( fragColor, orig, 1.0f - (float)(alpha)/100.0f );   
    write_imagef(dest_data,gl_FragCoord,retColor);
}



